function RNLTV_zooming_Fig13
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'zooming';

ExpFolderName = 'results';


ExpFolderPath = strjoin({curDir,ExpFolderName,application.name},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end
fileName_array = {'vesselss'};
fileName_array = {'boat256s' };

scale = 4;
nbIter = 1000;
radius = 5;
init = 16;

application.data_term = 1;

gama = 0.2;
lambda  = 1000;
mu=0.6;
hsigma=0.05;

for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    [Im0,map] = imread([fileName,'_4.png']);
    
    Im0 = double(Im0); in_clean = Im0/ max(Im0(:));
    
    % downsampling result: in_downs
    [Im0,map] = imread([fileName,'.png']);
    
    Im0 = double(Im0); in_downs = Im0/ max(Im0(:));
    
    [n_row, n_col] = size(in_downs);
    % that is N_original * N_zooming
    matrix_A   = make_A_s(n_row,n_col,scale);
    
    application.lam2HH_matrix = 2*lambda * (matrix_A'* matrix_A);
    application.lam2HT_matrix = 2*lambda * matrix_A';
    application.H_matrix = matrix_A;
    application.init_u = zeros(n_row*scale, n_col*scale);
    application.scale = scale;
    warning off;
    rng(8,'twister');
    
    [u,v,energies] = regularized_NLTV(in_downs,nbIter,radius,mu,...
        lambda,gama, hsigma, init, application);
    
    psnr = psnr1(u,in_clean)
    
    imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
        [fileName,application.name ]},filesep);
    
    % save image results
    save([imgResultNameFolderPath '_u_.mat'],'u');
end

end


% generate the sparse matrix of sub-sampling operator
%
%   Authors: Chen Yunjin
%
%
function [A] = make_A_s(M,N,scale)
row = zeros(1,M*N*scale^2);
col = zeros(1,M*N*scale^2);
val = zeros(1,M*N*scale^2);
for m = 1:M
    for n = 1:N
        index      = (m - 1)*N + n;
        row((index - 1)*scale^2 + 1:index*scale^2) = index;
        val((index - 1)*scale^2 + 1:index*scale^2) = 1/scale^2;
        for sr = 1:scale
            for sc = 1:scale
                inter_index = (sr - 1)*scale + sc;
                t_row = scale*(m - 1);
                col((index - 1)*scale^2 + inter_index) = (t_row + sr - 1)*(scale*N) ...
                    + (n - 1)*scale + sc;
            end
        end
    end
end
A = sparse(row,col,val,M*N,M*N*scale^2);
end


